﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.EntityModels;
    using Shared.UserModels.AppointmentCheck;
    using Utilities;

    /// <inheritdoc />
    [Authorize]
    [Route("api/check-points")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class AppointmentCheckPointsController : BaseController
    {
        /// <summary>
        /// The coupon services.
        /// </summary>
        private readonly IAppointmentCheckService service;

        /// <inheritdoc />
        public AppointmentCheckPointsController(IAppointmentCheckService service)
        {
            this.service = service;
        }

        /// <summary>
        /// The fetch coupons.
        /// </summary>
        /// <param name="model">
        /// The coupon filter model.
        /// </param>
        /// <returns>
        /// The list of coupons.
        /// </returns>
        [HttpPost]
        [Route("fetch")]
        [ProducesResponseType(typeof(List<FetchModel>), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchAsync([FromBody]FetchPayload model)
        {
            try
            {
                var data = await this.service.FetchAsync(model);
                return this.Success(data);
            }catch(Exception ex)
            {
                return this.ServerError(ex.Message);
            }
        }
      

        /// <summary>
        /// The add coupon.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("add")]
        [ProducesResponseType(typeof(int), 200)]
        [ProducesResponseType(409)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> AddAsync([FromBody] InsertModel model)
        {         
            try
            {
                var response = await this.service.InsertAsync(model);
                return this.Success(response);
            }catch(Exception ex)
            {
                return this.ServerError(ex.Message);
            }
        }
    }
}